#!/usr/bin/perl -w
use strict;
exit 0 if (!-e "/etc/bit-monitoring/agent.cfg");
my $blob = undef;
my $obj = {};
if (open(FD,"</etc/bit-monitoring/agent.cfg")) {
    local$/=undef; $blob=<FD>; close(FD);
    $obj = eval 'my ' . $blob;
}
print <<EOT;
[main]

# monitoring_enabled - set this to 'false' to stop the agent from reporting
monitoring_enabled = $$obj{monitoring_enabled}

# reporting_hostname - name used to identify the agent at the monitoring server
reporting_hostname = $$obj{reporting_hostname}

# URL of the monitoring server API endpoint
destination_server = api-monitoring.bit.nl

# monitoring server API account name
identity = $$obj{identity}

# monitoring server API password
password = $$obj{password}

# check interval in seconds when no alarms have been reported
normal_report_interval = $$obj{normal_report_interval}

# check interval in seconds when alarms have been reported
alarm_report_interval = $$obj{alarm_report_interval}

# default timeout for plugins in seconds
plugin_timeout = 15

# possible loglevels, allowed values: error, warning, info
# default is 'warning', 'info' is similar to the '-v' flag
loglevel = info

# Linux only
# log to syslog or log file (/var/log/bit-monitoring.log)
# default is "file"
#log_type = "syslog"

# default namespace in which plugins are executed (Linux only)
# leave empty for none
default_namespace =

# location of the pidfile
#pidfile = ./run/bit-monitoring.pid

# HTTP(s) proxy for communicating with the API, [host]:[port]
EOT
if ($$obj{proxy}) {
    print "proxy = $$obj{proxy}\n";
} else {
    print "#proxy =\n";
}
